/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tiled.io.MapReader;
import tiled.io.MapWriter;
import tiled.mapeditor.Resources;
import tiled.mapeditor.plugin.PluginClassLoader;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class PluginDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private final PluginClassLoader pluginLoader;
    private JList pluginList;
    private JButton closeButton;
    private JButton infoButton;
    private JButton removeButton;
    private static final String DIALOG_TITLE = Resources.getString("dialog.plugins.title");
    private static final String INFO_BUTTON = Resources.getString("dialog.plugins.info.button");
    private static final String REMOVE_BUTTON = Resources.getString("general.button.remove");
    private static final String CLOSE_BUTTON = Resources.getString("general.button.close");

    public PluginDialog(JFrame parent, PluginClassLoader pluginLoader) {
        super(parent, DIALOG_TITLE, true);
        this.pluginLoader = pluginLoader;
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void init() {
        try {
            int i;
            MapReader[] readers = this.pluginLoader.getReaders();
            MapWriter[] writers = this.pluginLoader.getWriters();
            String[] plugins = new String[readers.length + writers.length];
            for (i = 0; i < readers.length; ++i) {
                plugins[i] = readers[i].getPluginPackage();
            }
            for (i = 0; i < writers.length; ++i) {
                plugins[i + readers.length] = writers[i].getPluginPackage();
            }
            this.pluginList = new JList<String>(plugins);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.pluginList = new JList();
        }
        this.pluginList.addListSelectionListener(this);
        JScrollPane pluginScrollPane = new JScrollPane(this.pluginList);
        pluginScrollPane.setAutoscrolls(true);
        pluginScrollPane.setPreferredSize(new Dimension(200, 150));
        this.infoButton = new JButton(INFO_BUTTON);
        this.removeButton = new JButton(REMOVE_BUTTON);
        this.closeButton = new JButton(CLOSE_BUTTON);
        this.infoButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        VerticalStaticJPanel buttonPanel = new VerticalStaticJPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.infoButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.closeButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(pluginScrollPane);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setDefaultCloseOperation(2);
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.dispose();
        } else if (source != this.removeButton && source == this.infoButton) {
            JDialog info = new JDialog(this);
            JTextArea ta = new JTextArea(25, 30);
            int index = this.pluginList.getSelectedIndex();
            try {
                MapReader[] readers = this.pluginLoader.getReaders();
                MapWriter[] writers = this.pluginLoader.getWriters();
                if (index < readers.length) {
                    ta.setText(readers[index].getDescription());
                    info.setTitle(readers[index].getPluginPackage());
                } else {
                    ta.setText(writers[index -= readers.length].getDescription());
                    info.setTitle(writers[index].getPluginPackage());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ta.setEditable(false);
            ta.setFont(new Font("Monospaced", 0, 12));
            info.getContentPane().add(ta);
            info.setLocationRelativeTo(this);
            info.pack();
            info.setVisible(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        boolean validSelection = this.pluginList.getSelectedIndex() >= 0;
        this.infoButton.setEnabled(validSelection);
        if (validSelection) {
            // empty if block
        }
        this.removeButton.setEnabled(false);
    }
}

